# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#####################################################################
#                                                                   #
# Module:  CSMDefs.pm                                               #
#                                                                   #
#                                                                   #
# Description:   This module contains definitions used by CSM       #
#                commands.  These are definitions of CSM            #
#                directories and commands.  These definitions       #
#                are not specific to any operating system or        #
#                distribution.                                      #
#                                                                   #
# Subroutines:   None                                               #
#                                                                   #
# Notes:                                                            #
#                                                                   #
#####################################################################
# @(#)46   1.45   src/csm/core/pm/CSMDefs.pm.perl, setup, csm_rameh, rameh0431a 6/25/04 18:00:42

package CSMDefs;

BEGIN
{
    use File::Basename;    # - this gives us the path of the command
    ($::Bin) = dirname($0);    # - for this command we assume the modules and
                               #     message maps are in the same place
}
use lib "$::Bin";

use NodeUtils;

#-------------------------------------------------------------------
#    Global Definitions
#-------------------------------------------------------------------

#--Default Values--
$::MS_INSTALL_SERVER = 1;   #management server is an install server (by default)
$::SERVER_DIRECTORY  =
  "/csmserver";    #directory used to store CSM repository on Install servers

$::NOK = 1;
$::OK  = 0;

# The string that indicates a "Lite" node
$::CSMLITE = 'MinManaged';

# To disable CSMLITE, uncomment the following line.
#$::CSMLITE = `/bin/date`;

$::LCSEXT   = "true";    # LCS extension rpms on CSM CD?
$::ITDAGENT = "true";    # ITDAgent rpm on CSM CD?

# CSM and RSCT Directories
$::CSMTOP           = "/opt/csm";
$::CSMREQS          = $::CSMTOP . "/reqs";
$::CSMBIN           = $::CSMTOP . "/bin";
$::CSMCSMBIN        = $::CSMTOP . "/csmbin";
$::OPTCSMINSTALL    = $::CSMTOP . "/install";
$::RSCTBIN          = "/usr/sbin/rsct/bin";
$::TFTPBOOT         = "/tftpboot";
$::PXELINUX_CFG_DIR = "/tftpboot/pxelinux.cfg";
$::CSMSTATUSDIR     = "/csminstall/csm/status";
$::CSMINSTDIR       = "/csminstall";
$::CSMCFGDIR        = $::CSMINSTDIR . "/csm/config/";

#$::CSMSTATUSLINK	 = $::CSMINSTDIR . "/csm/status"; #obsolete
$::CSMCLIENTMNTDIR = "/var/opt/csm/mnt";

# CSM Files
$::NODEMAP_FILE = "$::CSMCFGDIR/nodemap";
$::CFGINFOFILE  = "/opt/csm/install/configinfo";

# CSM and RSCT Commands
$::ADDLCSEXT          = $::CSMBIN . "/addlcsext";
$::CFORCE             = $::CSMBIN . "/cfmupdatenode";
$::CHHWDEV            = $::CSMBIN . "/chhwdev";
$::CHNODE             = $::CSMBIN . "/chnode";
$::CREATEDHCP         = $::CSMCSMBIN . "/createdhcp";
$::CREATEHWDEV        = $::CSMCSMBIN . "/createhwdev";
$::CREATENODE         = $::CSMCSMBIN . "/createnode";
$::CSM2NIMGRPS        = $::CSMBIN . "/csm2nimgrps";
$::CSM2NIMNODES       = $::CSMBIN . "/csm2nimnodes";
$::DSH                = $::CSMBIN . "/dsh";
$::GETMACS            = $::CSMBIN . "/getmacs";
$::HWDEVGRP           = $::CSMBIN . "/hwdevgrp";
$::LSCONDRESP         = $::RSCTBIN . "/lscondresp";
$::LSHWDEV            = $::CSMBIN . "/lshwdev";
$::LSNODE             = $::CSMBIN . "/lsnode";
$::MGMTSVR            = $::CSMBIN . "/mgmtsvr";
$::MKGETMACRD         = $::CSMCSMBIN . "/mkgetmacrd";
$::MONITORINSTALL     = $::CSMBIN . "/monitorinstall";
$::NODEGRP            = $::CSMBIN . "/nodegrp";
$::REMOTESHELL_EXPECT = $::CSMCSMBIN . "/remoteshell.expect";
$::RMCONDRESP         = $::RSCTBIN . "/rmcondresp";
$::RMHWDEV            = $::CSMBIN . "/rmhwdev";
$::RMLCSEXT           = $::CSMBIN . "/rmlcsext";
$::RMNODE             = $::CSMBIN . "/rmnode";
$::RPOWER             = $::CSMBIN . "/rpower";
$::SMSUPDATENODE      = $::CSMBIN . "/smsupdatenode";
$::STARTCONDRESP      = $::RSCTBIN . "/startcondresp";
$::UPDATEDHCP         = $::CSMCSMBIN . "/updatedhcp";
$::UPDATENODE         = $::CSMBIN . "/updatenode";

# Logfiles
$::LOGFILE_HANDLE   = undef;
$::CSMLOG           = "/var/log/csm";
$::CSMSETUPKS_LOG   = $::CSMLOG . "/csmsetupks.log";
$::CSMSETUPYAST_LOG = $::CSMLOG . "/csmsetupyast.log";
$::INSTALLNODE_LOG  = $::CSMLOG . "/installnode.log";
$::MAKENODE_LOG     = $::CSMLOG . "/makenode.log";
$::UPDATENODE_LOG   = $::CSMLOG . "/updatenode.log";
$::CSMPREREBOOT_LOG = $::CSMLOG . "/csmprereboot.log";
$::CSMFIRSTBOOT_LOG = $::CSMLOG . "/csmfirstboot.log";
$::INSTALLMSLOG     = $::CSMLOG . "/installms.log";
$::CSMSETUPSIS_LOG  = $::CSMLOG . "/csmsetupsis.log";
$::COPYSISRPMS_LOG  = $::CSMLOG . "/copysisrpms.log";
$::MKSIIMAGE_LOG    = $::CSMLOG . "/mksiimage.log";
$::HAMS_LOG         = $::CSMLOG . "/hams/hams.log";
$::INSTALL_LOG      = "/var/log/csm/install.log";
$::GETADAPTERS_LOG  = $::CSMLOG . "/getadapters/getadapters.log";

# locations of OS and package definition files
$::OSDEFS  = $::OPTCSMINSTALL . "/defs";
$::PKGDEFS = $::OPTCSMINSTALL . "/pkgdefs";

# locations of user-provided customization scripts and data files
$::SCRIPTDIR      = "/csminstall/csm/scripts";
$::PREINSTALLDIR  = "$::SCRIPTDIR/installprereboot";
$::POSTINSTALLDIR = "$::SCRIPTDIR/installpostreboot";
$::UPDATEDIR      = "$::SCRIPTDIR/update";
$::SCRIPTDATADIR  = "$::SCRIPTDIR/data";

#$::PLTFRM               = InstallUtils->get_OSName();
if (NodeUtils->isLinux() == 1)
{
    $::PLTFRM = "Linux";
}
elsif (NodeUtils->isAIX() == 1)
{
    $::PLTFRM = "AIX";
}

# These variables are required to determine which .pm files to load
# They are used by get_DistributionVersion, get_PkgArchitecture & get_CSMVersion
if ($::PLTFRM eq "AIX")
{
    $::UNAME  = "/bin/uname";
    $::RPMCMD = "/bin/rpm";
    $::LSLPP  = "/bin/lslpp";
}
elsif ($::PLTFRM eq "Linux")
{
    $::UNAME  = "/bin/uname";
    $::RPMCMD = "/bin/rpm";
}

$::DISTRIBUTION = NodeUtils->distribution();

# List of supported distributions
@::VALID_DISTROS = (
                    'RedHat 7.2',
                    'RedHat 7.3',
                    'RedHatAS 2.1',
                    'RedHatEL-ES 2.1',
                    'RedHatEL-WS 2.1',
                    'RedHatEL-AS 3',
                    'RedHatEL-ES 3',
                    'RedHatEL-WS 3',
                    'RedHat 8.0',
                    'RedHat 9',
                    'SuSE 8.0',
                    'SuSE 8.1',
                    'SuSE 8.2',
                    'SLES 7.2',
                    'SLES 8.1',
                    'SLES 9',
                    );
@::VALID_AIX_DISTROS =
  ('AIX5.1', 'AIX5.1.0', 'AIX5.2', 'AIX5.2.0', 'AIX5.3', 'AIX5.3.0',);
@::VALID_CSM_DISTROS = (
                        '1.1.0', '1.1.1', '1.1.2', '1.1.3', '1.2.0', '1.3.0',
                        '1.3.1', '1.3.2', '1.3.3', '1.4.0',
                        );

@::VALID_X86_ARCHS = ('noarch', 'i286', 'i386', 'i486', 'i586', 'i686',);

@::VALID_X86_64_ARCHS = ('noarch', 'x86_64', 'i386', 'i486', 'i586', 'i686',);

@::VALID_IA64_ARCHS = ('noarch', 'ia64');

@::VALID_PPC_ARCHS = ('noarch', 'ppc', 'ppc64',);

$::DISTRO            = "";
@::valid_powermethod = ();
@::valid_console     = ();

1;
